<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

// Include the configuration files.
require ("../config_database.php");
require ("../config_settings.php");
require ("../config_admin.php");

// Make sure the person is logged in.
require ("./loginverify.php");

/*
 * Include the functions. Start the page timer, output the opening HTML,
 * and verify that we can actually connect to the database.
*/
require ("./functions.php");
	$start_time = micro_time(0);
	bodyHeader('code_gen', $version_num);
	bodyNavigation('code_gen');
	check_db_connection($adlogger_db_connect, $adlogger_db_select);

?>

<div id="side-bar">
	<div>
		<p class="sideBarTitle">Code Generators</p>
	</div>
</div>
<div id="main-copy">
	<?php
		if ($_SERVER['QUERY_STRING'] == 'tracking') {
			include("./includes/tracking.php");
		} elseif  ($_SERVER['QUERY_STRING'] == 'wrapping') {
			include("./includes/wrapping.php");
		} elseif  ($_SERVER['QUERY_STRING'] == 'cache_control') {
			include("./includes/cache_control.php");
		} elseif  ($_SERVER['QUERY_STRING'] == 'other_links') {
			include("./includes/other_links.php");
		} else {
		?>
			<h1 id="code_gen">Code Setup</h1>
			<p>There are 3 code generators to help you setup AdLogger on your website. In order to properly log clicks, all 3 must be used.</p>
			<ul>
				<li><strong>Tracking Code:</strong>
					<ul>
						<li>This is the code that logs clicks on your ads. Put the tracking code at the bottom of every AdSense page immediately before the &lt;/body&gt; tag.</li>
					</ul>
				</li>
				<li><strong>Wrapping Code:</strong>
					<ul>
						<li>With this code, you can disable ads for a certain IP address, a range of IP addresses, and/or people that are clicking too many ads within a set time period. Optionally, if ads are successfully banned for the visitor, you can have an alternate ad or code appear.</li>
					</ul>
				</li>
				<li><strong>Cache-Control Code:</strong>
					<ul>
						<li>This forces the web page to reload the webpage from the server each time the visitor accesses it. Ordinarily, the visitor's browser cache's the page, which prevents accurate logging or ad-disabling.</li>
					</ul>
				</li>
			</ul>
			<p>Choose which generator you want from the submenu above to begin.</p>
	<?php }	?>
</div>

<?php bodyFooter('code_gen', $start_time); ?>